#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <stdbool.h>
#include <time.h>
#include "linux_sdk_api.h"

void testsdk(char **argv)
{
    void *phandle = NULL;
    int result = 0;
    char str_test_jpg_path[PATH_MAX] = {0};
    char str_test_jpg1_path[PATH_MAX] = {0};
    char str_test_png_path[PATH_MAX] = {0};
    int full_length = 0;
    int name_length = 0;
    char *pstr_name = strrchr(argv[0], '/');
    char error_msg[1024] = {0};

    pstr_name++;
    full_length = strlen(argv[0]);
    name_length = strlen(pstr_name);
    strncpy(str_test_jpg_path, argv[0], full_length - name_length);
    strcat(str_test_jpg_path, "test.jpg");
    strncpy(str_test_jpg1_path, argv[0], full_length - name_length);
    strcat(str_test_jpg1_path, "test2.jpg");
    //strncpy(str_test_png_path, argv[0], full_length - name_length);
    //strcat(str_test_png_path, "test.png");

    result = PrinterCreator(&phandle, "TP806");
    //result = PrtPrinterCreatorA(&phandle, "DT-230");
    //result = PrtPrinterCreatorA(&phandle, "PPTII-A");
    if (0 != result)
    {
        FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        return;
    }

    do
    {

        result = PortOpen(phandle, "USB,TP806");
        if (0 != result)
        {
            FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
            printf("%s\n", error_msg);
            //printf("PrtPortOpenA failed code %d\n", result);
            break;
        }

        result = PrinterInitialize(phandle);
        if (0 != result)
            printf("PrtPrinterInitialize failed code %d\n", result);

        //unsigned int print_status = 0;
        //result = PrtCheckPrinterState(phandle, &print_status);
        //if (0 != result)
        //    printf("PrtCheckPrinterState failed code %d\n", result);
        //else
        //    printf("*PrtCheckPrinterState status code %d\n", print_status);

#define HPRT_ALIGNMENT_CENTER 1
#define HPRT_TEXT_NORMAL_MODE 0
#define HPRT_TEXT_SIZE_0WIDTH 0
#define HPRT_TEXT_SIZE_1WIDTH 1
        result = PrintText(phandle,
                           "hprt linux sdk\n",
                           HPRT_ALIGNMENT_CENTER,
                           HPRT_TEXT_NORMAL_MODE,
                           HPRT_TEXT_SIZE_1WIDTH);
        if (0 != result)
            printf("PrtPrintText failed code %d\n", result);
        else
            FeedLine(phandle, 1);

#define HPRT_ALIGNMENT_CENTER 1
#define HPRT_BRACODE_HRI_NONE 0
#define HPRT_BARCODE_CODE128 73
        result = PrintBarCode(phandle, HPRT_BARCODE_CODE128, "{A123456", 2, 50, HPRT_ALIGNMENT_CENTER, HPRT_BRACODE_HRI_NONE);
        if (0 != result)
            printf("PrtPrintBarCode failed code %d\n", result);
        else
            FeedLine(phandle, 1);

#define HPRT_BARCODE_QRCODE1 103
#define HPRT_QRCODE_ERROR_CORRECTION_LEVEL_H 51
        result = PrintSymbol(phandle, HPRT_BARCODE_QRCODE1, "hprt linux sdk", HPRT_QRCODE_ERROR_CORRECTION_LEVEL_H, 5, 5, HPRT_ALIGNMENT_CENTER);
        if (0 != result)
            printf("PrtPrintSymbol failed code %d\n", result);
        else
            FeedLine(phandle, 1);

#define HPRT_PRINT_IMAGE_NORMAL 0
        result = PrintImage(phandle, str_test_jpg_path, HPRT_PRINT_IMAGE_NORMAL);
        if (0 != result)
            printf("PrtPrintImage failed code %d\n", result);
        else
            FeedLine(phandle, 1);

        result = DefineNVImage(phandle, str_test_jpg1_path, 'a', 'b');
        if (0 != result)
            printf("PrtDefineNVImage failed code %d\n", result);
        else
        {
            result = PrintNVImage(phandle, 'a', 'b');
            if (0 != result)
                printf("PrtPrintNVImage failed code %d\n", result);
            else
                FeedLine(phandle, 1);
        }

        /*  result = PrtDefineBufferedImageA(phandle, str_test_jpg1_path);
          if (0 != result)
              printf("PrtDefineBufferedImageA failed code %d\n", result);
          else
          {
              result = PrtPrintBufferedImage(phandle);
              if (0 != result)
                  printf("PrtPrintBufferedImage failed code %d\n", result);
              else
                  PrtFeedLine(phandle, 1);
          }*/

#define HPRT_FULL_CUT 0
#define HPRT_PARTIAL_CUT 1
        result = CutPaper(phandle, HPRT_FULL_CUT, 10);
        if (0 != result)
            printf("PrtCutPaper failed code %d\n", result);

        PortClose(phandle);
    }
    while (0);


    PrinterDestroy(phandle);
    phandle = NULL;
}

int main(int argc, char **argv)
{
    testsdk(argv);
    return 0;
}
