#ifndef _ESC_SDK_API_H_
#define _ESC_SDK_API_H_

#ifdef LINUX

#define SDK_API __attribute__ ((visibility("default")))
#define CALL_STACK
#define TCHAR char
#else

#include <tchar.h>
#ifdef EXPORT_STDCALL
#define CALL_STACK __stdcall
#else
#define CALL_STACK __cdecl
#endif

#ifdef __cplusplus
#define SDK_API extern "C" __declspec(dllexport)
#else
#define SDK_API __declspec(dllexport)
#endif

#endif

//new func v1.2.1
SDK_API int CALL_STACK SetLog(int enable, const TCHAR* path);

SDK_API void CALL_STACK FormatError(int errorNo, int langid, unsigned char* buf, int pos, int bufSize);
SDK_API int CALL_STACK PrinterCreator(void** phandle, const TCHAR* model);
SDK_API void* CALL_STACK PrinterCreatorS(char* model);
SDK_API int CALL_STACK PrinterDestroy(void* handle);

SDK_API int CALL_STACK PortOpen(void* handle, const TCHAR* ioSettings);
SDK_API int CALL_STACK PortClose(void* handle);

SDK_API int CALL_STACK DirectIO(void* handle, unsigned char* writedata, unsigned int writeNum, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum);
SDK_API int CALL_STACK WriteData(void* handle, unsigned char* writeData, unsigned int writeNum);
SDK_API int CALL_STACK ReadData(void* handle, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum);
SDK_API int CALL_STACK ReadDataEOF(void* handle, unsigned char* readData, unsigned int offSet, unsigned int bufLength, unsigned char soh, unsigned char eof, unsigned int* preadedNum);
SDK_API int CALL_STACK PrinterInitialize(void* handle);
SDK_API int CALL_STACK FeedLine(void* handle,int lines);
SDK_API int CALL_STACK SetAlign(void* handle, int align);
SDK_API int CALL_STACK PrintText(void* handle,const TCHAR* data,int alignment,int attribute,int textSize);
SDK_API int CALL_STACK PrintTextS(void* handle,const TCHAR* data);
SDK_API int CALL_STACK PrintBarCode(void* handle,int bcType, const TCHAR* data,int width,int height,int alignment,int hriPosition);
SDK_API int CALL_STACK PrintSymbol(void* handle,int type,const TCHAR* data,int errLevel,int width,int height,int alignment);

SDK_API int CALL_STACK CutPaper(void* handle,int cutMode,int distance);
SDK_API int CALL_STACK OpenCashDrawer(void* handle,int pin_mode,int onTime,int offTime);
SDK_API int CALL_STACK SelectStandardMode(void* handle);
SDK_API int CALL_STACK SetTextLineSpace(void* handle,int lineSpace);
SDK_API int CALL_STACK SetTextBold(void* handle, int bold);
SDK_API int CALL_STACK SetTextFont(void* handle, int font);
SDK_API int CALL_STACK SelectPageMode(void* handle);
SDK_API int CALL_STACK SetPrintAreaInPageMode(void* handle,int horizontal,int vertical,int width,int height);
SDK_API int CALL_STACK CancelPrintDataInPageMode(void* handle);
SDK_API int CALL_STACK SelectPrintDirectionInPageMode(void* handle,int direction);
SDK_API int CALL_STACK SetAbsolutePrintPosition(void* handle, int position);
SDK_API int CALL_STACK SetAbsoluteVerticalPrintPositionInPageMode(void* handle,int position);
SDK_API int CALL_STACK PrintAndReturnStandardMode(void* handle);
SDK_API int CALL_STACK PositionNextLabel(void* handle);
SDK_API int CALL_STACK PrintDataInPageMode(void* handle);
SDK_API int CALL_STACK GetPrinterState(void* handle,unsigned int* printerStatus);
SDK_API int CALL_STACK SetCodePage(void* handle,int codepage,int type);
SDK_API int CALL_STACK SetBuzzer(void* handle,int enable);
SDK_API int CALL_STACK SetInternationalCharacter(void* handle,int characterSet);
SDK_API int CALL_STACK SetPrintSpeed(void* handle,int speed);

//Print Image

SDK_API int CALL_STACK DefineNVImageCompatible(void* handle, const TCHAR** fileNameList, int imageQty);
SDK_API int CALL_STACK PrintNVImageCompatible(void* handle, int imgno, int scaleMode);
SDK_API int CALL_STACK DefineDownloadedImageCompatible(void* handle, const TCHAR* fileName);
SDK_API int CALL_STACK PrintDownloadedImageCompatible(void* handle, int scaleMode);

SDK_API int CALL_STACK PrintImage(void* handle,const TCHAR* imagePath,int scaleMode);
SDK_API int CALL_STACK DefineNVImage(void* handle,const TCHAR* imagePath,unsigned char kc1,unsigned char kc2);
SDK_API int CALL_STACK PrintNVImage(void* handle,unsigned char kc1,unsigned char kc2);
SDK_API int CALL_STACK DefineDownloadedImage(void* handle,const TCHAR* imagePath,unsigned char kc1,unsigned char kc2);
SDK_API int CALL_STACK DefineBufferedImage(void* handle,const TCHAR* imagePath);
SDK_API int CALL_STACK PrintBufferedImage(void* handle);
SDK_API int CALL_STACK DeleteAllNVImages(void* handle);

SDK_API int CALL_STACK GetFirmwareVersion(void* handle,int* version,int versionLen);
SDK_API int CALL_STACK GetCashDrawerState(void* handle, int* drawerState);
SDK_API int CALL_STACK ClearBuffer(void* handle);
SDK_API int CALL_STACK PrintBitMapData(void* handle, int scaleMode, int width, int height, unsigned char* data);
SDK_API int CALL_STACK PrintTwoQRCode(void* handle, const TCHAR* data1, int width1, int hAlign1, int vAlign1, const TCHAR* data2, int width2, int hAlign2, int vAlign2);
#endif /*WIN32_SDK_H*/
